# -*- coding: utf-8 -*-
"""
Global configuration file for TG2-specific settings in testtg2.

This file complements development/deployment.ini.

Please note that **all the argument values are strings**. If you want to
convert them into boolean, for example, you should use the
:func:`paste.deploy.converters.asbool` function, as in::
    
    from paste.deploy.converters import asbool
    setting = asbool(global_conf.get('the_setting'))
 
"""

from tg.configuration import AppConfig

import testtg2
from testtg2 import model
from testtg2.lib import app_globals, helpers 

class TestConfig(AppConfig):
    def add_auth_middleware(self, app, *args):
        """ Add our FAS authentication middleware """
        from fedora.wsgi.faswho.faswhoplugin import make_faswho_middleware
        from repoze.what.plugins.pylonshq import booleanize_predicates
        from copy import copy
        import logging

        # Configuring auth logging:
        if 'log_stream' not in self.fas_auth:
            self.fas_auth['log_stream'] = logging.getLogger('auth')

        auth_args = copy(self.fas_auth)

        app = make_faswho_middleware(app, **auth_args)
        return app


base_config = TestConfig()
base_config.renderers = []

base_config.package = testtg2

#Enable json in expose
base_config.renderers.append('json')
#Set the default renderer
base_config.default_renderer = 'mako'
base_config.renderers.append('mako')

#Configure the base SQLALchemy Setup
base_config.use_sqlalchemy = True
base_config.model = testtg2.model
base_config.DBSession = testtg2.model.DBSession

# Configure the authentication backend

# YOU MUST CHANGE THIS VALUE IN PRODUCTION TO SECURE YOUR APP 
base_config.sa_auth.cookie_secret = "ChangeME" 

base_config.auth_backend = 'sqlalchemy'
base_config.sa_auth.dbsession = model.DBSession
from tg.configuration import Bunch
base_config.fas_auth = Bunch()
# what is the class you want to use to search for users in the database
base_config.sa_auth.user_class = model.User
# what is the class you want to use to search for groups in the database
base_config.sa_auth.group_class = model.Group
# what is the class you want to use to search for permissions in the database
base_config.sa_auth.permission_class = model.Permission

# override this if you would like to provide a different who plugin for
# managing login and logout of your application
base_config.sa_auth.form_plugin = None

# override this if you are using a different charset for the login form
base_config.sa_auth.charset = 'utf-8'

# You may optionally define a page where you want users to be redirected to
# on login:
base_config.sa_auth.post_login_url = '/post_login'

# You may optionally define a page where you want users to be redirected to
# on logout:
base_config.sa_auth.post_logout_url = '/post_logout'
